<?php

//  MP3-Player 1.1
//  © S.G.Schiffer 2025 - sgs-visual.de
//
// Dieses Script darf nur mit der Quellenangabe (sgs-visual.de) genutzt werden!
// Dieses Script darf nicht auf anderen Domains angeboten oder verkauft werden!
// 
// Ich übernehme keine Haftung für die Funktionalität meines Scriptes oder Korrektheit der ausgegeben Daten.
// Es gibt keinen Anspruch auf Schadens- oder Ersatzansprüche durch die Nutzung des Scriptes.
// Es gibt keinen Support für Probleme, die bei der Anpassung des Scriptes entstehen können.
// -----------------------------------------------------------------------

session_start();
$password = "passwort"; // Ersetzen Sie hier das "passwort" in Ihr eigenes Passwort. Groß- Kleinschreibung beachten.

// Password validation
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
        if ($_POST['password'] === $password) {
            $_SESSION['authenticated'] = true;
        } else {
            $error = "Falsches Passwort!";
        }
    }

    if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
        ?>
        <!DOCTYPE html>
        <html lang="de">
        <head>
            <meta charset="UTF-8">
            <title>MP3 Player V 1.1 - Musiktitel bearbeiten - Dateien löschen</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #333;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                    margin: 0;
                }
                .container {
                    width: 600px;
                    background-color: #333;
                    color: #FFF;
                    padding: 20px;
                    border-radius: 5px;
                    text-align: center;
                }
                h1 {
                    font-size: 16px;
                    font-weight: 600;
                }
                p {
                    font-size: 14px;
                }
                .error {
                    color: #ff0000;
                }
                .login-btn {
                    background-color: #ff0000;
                    color: #fff;
                    border: none;
                    padding: 8px 15px;
                    border-radius: 4px;
                    cursor: pointer;
                    font-size: 14px;
                    display: inline-flex;
                    align-items: center;
                }
                .login-btn img {
                    margin-right: 5px;
                }
                input[type="password"] {
                    padding: 8px;
                    width: 200px;
                    margin-right: 10px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h1>MP3 Player V. 1.1 - Musiktitel bearbeiten - Dateien löschen<br>Login</h1>
                <?php if (isset($error)): ?>
                    <p class="error"><?php echo $error; ?></p>
                <?php endif; ?>
                <form method="post">
                    <input type="password" name="password" placeholder="Passwort eingeben">
                    <button type="submit" class="login-btn">
                        <img src="icons/login.png" width="16" height="16" alt="Login">
                        Login
                    </button>
      <p style='font-size: 9px;text-align: center;'>
         &copy; S.G.Schiffer 2025 - 
        <a style='text-decoration:none;color:#FF0000;font-weight:600;' href='https://www.sgs-visual.de' target='_blank'>sgs-visual.de</a>
      </p>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Handle file deletion
if (isset($_POST['delete']) && !empty($_POST['file'])) {
    $file = $_POST['file'];
    $filePath = 'sounds/' . $file;

    if (file_exists($filePath) && unlink($filePath)) {
        // Also remove from JSON if exists
        $jsonFile = 'data/musik_titel.json';
        if (file_exists($jsonFile)) {
            $data = json_decode(file_get_contents($jsonFile), true) ?: [];
            if (isset($data[$file])) {
                unset($data[$file]);
                file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
            }
        }
        $deleteMessage = "Die Datei $file wurde gelöscht.";
    } else {
        $deleteMessage = "Die Datei $file konnte nicht gelöscht werden.";
    }
}

// Handle saving titles
if (isset($_POST['save_titles'])) {
    $titles = $_POST['titles'] ?? [];
    $data = [];

    foreach ($titles as $file => $title) {
        $data[$file] = $title;
    }

    if (!is_dir('data')) {
        mkdir('data', 0777, true);
    }

    file_put_contents('data/musik_titel.json', json_encode($data, JSON_PRETTY_PRINT));
    $saveMessage = "Titel wurden erfolgreich gespeichert.";
}

// Read existing titles from JSON
$titles = [];
if (file_exists('data/musik_titel.json')) {
    $titles = json_decode(file_get_contents('data/musik_titel.json'), true) ?: [];
}

// Get all music files
$musicFiles = [];
if (is_dir('sounds')) {
    $files = scandir('sounds');
    foreach ($files as $file) {
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        if (in_array($ext, ['mp3', 'ogg']) && $file != '.' && $file != '..') {
            $musicFiles[] = $file;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Musiktitel bearbeiten - Dateien löschen</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #333;
            display: flex;
            justify-content: center;
            padding: 30px 0;
            margin: 0;
        }
        .container {
            width: 600px;
            background-color: #333;
            color: #FFF;
            padding: 20px;
            border-radius: 5px;
        }
        h1 {
            font-size: 16px;
            font-weight: 600;
            text-align: center;
        }
        p {
            font-size: 14px;
        }
        .success {
            color: #4CAF50;
            text-align: center;
        }
        .error {
            color: #ff0000;
            text-align: center;
        }
        .btn {
            background-color: #ff0000;
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            text-decoration: none;
            margin: 10px 0;
        }
        .btn img {
            margin-right: 5px;
        }
        .button-group {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            gap: 30px;
        }
        .button-row {
            display: flex;
            justify-content: center;
            margin-top: 10px;
            gap: 30px;
        }
        .file-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .file-table tr {
            border-bottom: 1px solid #555;
        }
        .file-table td {
            padding: 10px 5px;
            font-size: 14px;
        }
        .file-table input[type="text"] {
            width: 90%;
            padding: 6px;
            border-radius: 3px;
            border: 1px solid #ccc;
        }
        .delete-btn {
            background: none;
            border: none;
            cursor: pointer;
            padding: 0;
            display: flex;
            align-items: center;
            height: 100%;
        }
        .input-container {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .input-wrapper {
            flex-grow: 1;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Musiktitel bearbeiten und Dateien löschen</h1>

        <?php if (isset($deleteMessage)): ?>
            <p class="<?php echo (strpos($deleteMessage, 'nicht') !== false) ? 'error' : 'success'; ?>">
                <?php echo $deleteMessage; ?>
            </p>
        <?php endif; ?>

        <?php if (isset($saveMessage)): ?>
            <p class="success"><?php echo $saveMessage; ?></p>
        <?php endif; ?>

        <form method="post">
            <div class="file-table">
                <?php if (empty($musicFiles)): ?>
                    <p style="text-align:center;">Keine Musikdateien vorhanden.</p>
                <?php else: ?>
                    <?php foreach ($musicFiles as $file): ?>
                        <div style="margin-bottom: 15px;">
                            <div><?php echo $file; ?></div>
                            <div class="input-container">
                                <div class="input-wrapper">
                                    <input type="text" name="titles[<?php echo $file; ?>]"
                                           value="<?php echo isset($titles[$file]) ? htmlspecialchars($titles[$file]) : ''; ?>"
                                           placeholder="Titel">
                                </div>
                                <button type="button" class="delete-btn" onclick="confirmDelete('<?php echo $file; ?>')">
                                    <img src="icons/loeschen.png" width="16" height="16" alt="Löschen">
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <div class="button-group">
                <button type="submit" name="save_titles" class="btn">
                    <img src="icons/speichern.png" width="16" height="16" alt="Speichern">
                    Speichern
                </button>
                <a href="musik_hochladen.php" class="btn"><img src="icons/upload.png" width="16" height="16" alt="Hochladen">
                    Datei hochladen
                </a>
            </div>

            <div class="button-row">
                <button type="button" class="btn" onclick="openPlayer()">
                    Player
                </button>
                <a href="?logout=1" class="btn">
                    <img src="icons/logout.png" width="16" height="16" alt="Logout">
                    Logout
                </a>
            </div>
        </form>

        <!-- Form for deletion -->
        <form id="deleteForm" method="post" style="display:none;">
            <input type="hidden" name="file" id="fileToDelete">
            <input type="hidden" name="delete" value="1">
        </form>
    </div>

    <script>
        function confirmDelete(file) {
            if (confirm('Datei ' + file + ' wirklich löschen?')) {
                document.getElementById('fileToDelete').value = file;
                document.getElementById('deleteForm').submit();
            }
        }

        function openPlayer() {
            var popup = window.open('mp3_player.php', 'player',
                                    'width=700,height=600,scrollbars=yes');
            if (popup) {
                popup.focus();
            } else {
                alert('Popup wurde blockiert. Bitte erlaube Popups für diese Seite.');
            }
        }
    </script>
</body>
</html>

<?php
// Logout functionality
if (isset($_GET['logout'])) {
    session_unset();
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>